<?php

namespace Modules\Core\Utilities;

use Illuminate\Database\Events\QueryExecuted;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class QueryListener
{
    /**
     * Executed Query Counter
     *
     * @var int
     */
    protected static int $queriesCount = 0;

    /**
     * Listen to all executed queries
     *
     * @return void
     */
    public static function listen(): void
    {
        if (!app()->environment(['local', 'testing']) || !config('database.enable_query_log')) {
            return;
        }

        DB::listen(function (QueryExecuted $query) {
            self::$queriesCount++;

            Log::debug($query->toRawSql());
            Log::debug("execution time: " . $query->time . ' ms');
            Log::debug('Total Queries Executed: ' . self::$queriesCount);
            Log::debug('--------------------');
        });
    }
}
