<?php

namespace Modules\Order\Http\Requests\Api\V1;

use Modules\Core\Http\Requests\Request;

class CancelOrRefundOrderRequest extends Request
{
    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            "reason_id" => "bail|required|exists:reasons,id,deleted_at,NULL,is_active,1",
            "pos_register_id" => "bail|required|numeric|exists:pos_registers,id,deleted_at,NULL,is_active,1",
            "note" => "nullable|string|max:1000",
        ];
    }

    /** @inheritDoc */
    protected function availableAttributes(): string
    {
        return "order::attributes.cancel_or_refund";
    }
}
