<?php

use Modules\Order\Http\Controllers\Api\V1\OrderController;
use Modules\Order\Http\Controllers\Api\V1\ReasonController;

Route::controller(OrderController::class)
    ->prefix('orders')
    ->group(function () {
        Route::get('/', 'index')->middleware('can:admin.orders.index');
        Route::get('/{orderId}/show', 'show')->middleware('can:admin.orders.show');
        Route::get('/{orderId}/meta/edit', 'getFormEditMeta')->middleware('can:admin.orders.edit');
        Route::get('/{orderId}/print', 'print')->middleware('can:admin.orders.print_receipt');
        Route::post('/', 'store')->middleware('can:admin.orders.create');
        Route::put('/{orderId}', 'update')->middleware('can:admin.orders.edit');
        Route::post('/{orderId}/cancel', 'cancel')->middleware('can:admin.orders.cancel');
        Route::post('/{orderId}/refund', 'refund')->middleware('can:admin.orders.refund');
        Route::get('/{orderId}/update-status/meta', 'getUpdateStatusMeta')
            ->middleware('permission:admin.orders.cancel|admin.orders.refund');
        Route::get('active', 'activeOrders')
            ->middleware('can:admin.orders.active');
        Route::get('upcoming', 'upcomingOrders')
            ->middleware('can:admin.orders.upcoming');
        Route::post('{orderId}/add-payment', 'addPayment')
            ->middleware('can:admin.orders.receive_payment');
        Route::post('{id}/add-payment-merge', 'addPaymentMerge')
            ->middleware('can:admin.orders.receive_payment');
        Route::get('{orderId}/add-payment/meta', 'getAddPaymentMeta')
            ->middleware('can:admin.orders.receive_payment');

        Route::patch('/{orderId}/move-to-next-status', 'moveToNextStatus')->middleware('can:admin.orders.update_status');
    });

Route::controller(ReasonController::class)
    ->prefix('reasons')
    ->group(function () {
        Route::get('/', 'index')->middleware('can:admin.reasons.index');
        Route::get('/{id}', 'show')->middleware('permission:admin.reasons.show|admin.reasons.edit');
        Route::post('/', 'store')->middleware('can:admin.reasons.create');
        Route::put('/{id}', 'update')->middleware('can:admin.reasons.edit');
        Route::delete('/{ids}', 'destroy')->middleware('can:admin.reasons.destroy');
        Route::get('/form/meta', 'getFormMeta')->middleware('permission:admin.reasons.edit|admin.reasons.create');
    });
