<?php

namespace Modules\Printer\Templates;

use Modules\Printer\Contracts\BufferTemplateInterface;
use Str;

class ReceiptBufferTemplate implements BufferTemplateInterface
{
    /** @inheritDoc */
    public static function build(array $order): string
    {
        $buf = printCenterText($order['title'] ?? '') . "\n";
        $buf .= str_repeat('-', 40) . "\n";

        $buf .= __("printer::printers.template.order_number") . ': #' . $order['order_number'] . "\n";
        $buf .= __("printer::printers.template.reference") . ': ' . $order['reference_no'] . "\n";
        $buf .= __("printer::printers.template.type") . ': ' . $order['type']->trans() . "\n";
        $buf .= __("printer::printers.template.date") . ': ' . $order['date'] . ' ' . $order['time'] . "\n";
        $buf .= str_repeat('-', 40) . "\n";

        foreach ($order['items'] as $item) {
            $status = $item['status'] ?? null;

            $line = Str::limit($item['name'], 25);

            if (in_array($status->value, ['cancelled', 'refunded'])) {
                $line = '[' . mb_strtoupper(__("printer::printers.template.$status->value")) . '] ' . $line;
            }

            $line .= ' x' . $item['quantity'];
            $line .= ' ' . $item['total']->format();
            $buf .= $line . "\n";

            foreach ($item['options'] ?? [] as $option) {
                $name = $option['name'] ?? '-';
                $value = $option['value'] ?? '';

                $label = is_array($value)
                    ? implode(', ', array_map(fn($v) => $v['label'], $value))
                    : $value;

                $buf .= "    - {$name}: {$label}\n";
            }

            // Optional: show reason if exists
            if (!empty($item['reason'])) {
                $buf .= "    (" . __("printer::printers.template.reason") . ': ' . $item['reason'] . ")\n";
            }

            $buf .= "\n";
        }

        $buf .= str_repeat('-', 40) . "\n";
        $buf .= __("printer::printers.template.subtotal") . ': ' . $order['sub_total']->format() . "\n";
        if ($order['discount']) {
            $buf .= __("printer::printers.template.discount") . ': -' . $order['discount']->format() . "\n";
        }
        foreach ($order['taxes'] ?? [] as $tax) {
            $buf .= $tax['name'] . ': ' . $tax['amount']->format() . "\n";
        }

        $buf .= __("printer::printers.template.total") . ': ' . $order['total']->format() . "\n";
        $buf .= str_repeat('-', 40) . "\n";
        $buf .= printCenterText(__("printer::printers.template.footer_text")) . "\n";

        return $buf;
    }
}
