<?php

namespace App\Providers;

use DB;
use Exception;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Laravel\Sanctum\Sanctum;
use Modules\Core\Utilities\QueryListener;
use Modules\User\Models\PersonalAccessToken;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        $this->usePersonalAccessTokenModel();
        $this->strictModels();

        QueryListener::listen();

        Gate::before(fn($user) => $user->isSuperAdmin());

        try {
            Schema::defaultStringLength(191);
            DB::statement("SET sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))");
        } catch (Exception) {
        }

    }

    /**
     * Register the personal access tokens' model
     *
     * @return void
     */
    private function usePersonalAccessTokenModel(): void
    {
        Sanctum::usePersonalAccessTokenModel(PersonalAccessToken::class);
    }

    /**
     * The model should be strict to get optimal performance.
     *
     * @return void
     */
    private function strictModels(): void
    {
        Model::shouldBeStrict();
    }
}
