import { api } from '@/api'

export function index () {
  return api.get('/v1/cart/pos')
}

export function clear () {
  return api.delete('/v1/cart/pos/clear')
}

export function storeOrderType (type: string) {
  return api.post(`/v1/cart/pos/order-types/${type}`)
}

export function removeOrderType () {
  return api.delete('/v1/cart/pos/order-types/')
}

export function storeItem (params: Record<string, any>) {
  return api.post('/v1/cart/pos/items', params)
}

export function updateItem (id: string, qty: number) {
  return api.put(`/v1/cart/pos/items/${id}`, { qty })
}

export function deleteItem (id: string) {
  return api.delete(`/v1/cart/pos/items/${id}`)
}

export function applyDiscount (id: number) {
  return api.post(`/v1/cart/pos/discounts/${id}`)
}

export function removeDiscount () {
  return api.delete(`/v1/cart/pos/discounts`)
}

export function addCustomer (id: number) {
  return api.post(`/v1/cart/pos/customers/${id}`)
}

export function removeCustomer () {
  return api.delete(`/v1/cart/pos/customers`)
}

export function applyVoucher (code: string) {
  return api.post('/v1/cart/pos/vouchers', { code })
}

export function applyGift (id: number) {
  return api.post(`/v1/cart/pos/gifts/${id}`)
}
