import { api } from '@/api'

export function show (id: number, returnAllTranslations = false) {
  return api.get(`/v1/stock-movements/${id}`, { params: { return_all_translations: returnAllTranslations } })
}

export function update (id: number, item: Record<string, any>) {
  return api.put(`/v1/stock-movements/${id}`, item)
}

export function store (item: Record<string, any>) {
  return api.post(`/v1/stock-movements`, item)
}

export function getFormMeta (branchId?: number) {
  return api.get(`/v1/stock-movements/form/meta`, { params: { branch_id: branchId } })
}
