import { useI18n } from 'vue-i18n'
import { useToast } from 'vue-toastification'
import {
  activeOrders,
  addPayment,
  cancel,
  getAddPaymentMeta,
  getFormEditMeta,
  getPrintReceipt,
  getUpdateStatusMeta,
  moveToNextStatus,
  refund,
  show,
  store,
  upcomingOrders,
  update,
} from '@/api/sale/order.ts'

export function useOrder () {
  const toast = useToast()
  const { t } = useI18n()

  const getShowData = async (id: number | string): Promise<Record<string, any>> => {
    try {
      return { status: 200, data: (await show(id)).data.body }
    } catch (error: any) {
      if (error?.response?.status !== 404) {
        toast.error(t('core::errors.an_unexpected_error_occurred'))
      }
      return { status: error?.response?.status }
    }
  }

  const getFormEditMetaData = async (id: number | string): Promise<Record<string, any>> => {
    try {
      return { status: 200, data: (await getFormEditMeta(id)).data.body }
    } catch (error: any) {
      if (error?.response?.status !== 404) {
        toast.error(t('core::errors.an_unexpected_error_occurred'))
      }
      return { status: error?.response?.status }
    }
  }

  return {
    store,
    update,
    cancel,
    refund,
    getShowData,
    getUpdateStatusMeta,
    activeOrders,
    addPayment,
    upcomingOrders,
    getAddPaymentMeta,
    moveToNextStatus,
    getPrintReceipt,
    getFormEditMetaData,
  }
}
