export interface Price {
  amount: number
  formatted: string
  currency: string
}

export interface ProductTax {
  id: number
  name: string
  rate: number
  type: 'exclusive' | 'inclusive'
  order_types: string[]
  compound: boolean
}

export interface CartItemTax {
  id: number
  name: string
  type: 'exclusive' | 'inclusive'
  amount: number
}

export interface Product {
  id: number
  order_product_id?: number
  status?: Record<string, any>
  name: string
  thumbnail: string
  price: Price
  taxes?: ProductTax[] | null
}

export interface OptionValue {
  id: number
  label?: string | null
  price: Price
  price_type: 'fixed' | 'percent'
  value?: string | null
}

export interface Option {
  id: number
  name: string
  type: 'text' | 'textarea' | 'select' | 'checkbox' | 'date' | 'time' | 'radio' | 'multiple_select'
  values: OptionValue[] | OptionValue
}

export interface CartItemAction {
  action: string
  quantity: number
}

export interface CartItem {
  key: string
  product: Product
  options: Option[]
  taxes: CartItemTax[]
  actions: CartItemAction[]
  quantity: number
  price: number
  taxAmount: number
  totalWithTax: number
}

export interface Cart {
  mode: 'create' | 'edit'
  orderId?: number | string | null
  items: CartItem[]
  paymentMethods: string[]
  refund_payment_method?: string | null
  payments: Record<string, any>
  orderType: string | null
  taxes: Record<string, any>[]
  posRegisterId: number | null
  searchQuery: string | null
  notes: string | null
  tableId: number | null
  tableInfo: Record<string, any> | null
  guestCount: number
  checkoutStep: 'cart' | 'summary'
  paymentType: string
  amountToBePaid: number
  carPlate: string | null
  carDescription: string | null
  scheduledAt: string | null
}
