export const getOnlineMenuUrl = (slug: string) => {
  return `${window.origin}/online-menu/${slug}`
}

export const getProductThumbnail = (thumbnail?: string) => {
  return thumbnail || 'data:image/svg+xml;base64,' + btoa(`
    <svg width="300" height="200" xmlns="http://www.w3.org/2000/svg">
      <rect width="300" height="200" fill="#e0e0e0"/>
      <text x="50%" y="50%" font-size="20" text-anchor="middle" fill="#9e9e9e" dy=".3em">No Image</text>
    </svg>
  `)
}

/**
 * Generate a random voucher code
 *
 * @param {Object} options
 * @param {String} [options.prefix] - Optional prefix like "FORKIVA"
 * @param {Number} [options.length] - Number of random characters to append
 * @param {Boolean} [options.includeYear] - Append current year at the end
 * @returns {String}
 */
export function generateVoucherCode ({
  prefix = '',
  length = 6,
  includeYear = false,
} = {}) {
  const chars = 'ABCDEFGHJKMNPQRSTUVWXYZ23456789'
  let randomPart = ''

  for (let i = 0; i < length; i++) {
    randomPart += chars.charAt(Math.floor(Math.random() * chars.length))
  }

  let code = prefix ? `${prefix.toUpperCase()}-${randomPart}` : randomPart

  if (includeYear) {
    const year = new Date().getFullYear()
    code = `${code}${year}`
  }

  return code
}
