import type {
  NavigationGuardNext,
  RouteLocationNormalized,
  RouteLocationNormalizedLoaded,
  RouteLocationRaw,
} from 'vue-router'
import { useAuth } from '@/composables/user/auth.ts'

export function guestMiddleware (to: RouteLocationNormalized, from: RouteLocationNormalizedLoaded, next: NavigationGuardNext) {
  const auth = useAuth()

  if (!auth.store.getToken) {
    auth.store.restoreAuth()
  }

  if (auth.store.isAuthenticated) {
    next({ name: 'admin.dashboard' } as unknown as RouteLocationRaw)
  } else {
    next()
  }
}
