import type { RouteRecordRaw } from 'vue-router'
import { authMiddleware } from '@/middleware'
import { permissionMiddleware } from '@/middleware/permission.ts'
import { activityLogRoutes } from '@/router/routes/admin/activityLog.ts'
import { branchRoutes } from '@/router/routes/admin/branch.ts'
import { inventoryRoutes } from '@/router/routes/admin/inventory.ts'
import { localizationRoutes } from '@/router/routes/admin/localization.ts'
import { loyaltyRoutes } from '@/router/routes/admin/loyalty.ts'
import { mediaRoutes } from '@/router/routes/admin/media.ts'
import { menuRoutes } from '@/router/routes/admin/menu.ts'
import { optionRoutes } from '@/router/routes/admin/option.ts'
import { postRoutes } from '@/router/routes/admin/pos.ts'
import { printerRoutes } from '@/router/routes/admin/printer.ts'
import { promotionRoutes } from '@/router/routes/admin/promotion.ts'
import { reportRoutes } from '@/router/routes/admin/report.ts'
import { saleRoutes } from '@/router/routes/admin/sale.ts'
import { seatingPlanRoutes } from '@/router/routes/admin/seatingPlan.ts'
import { settingRoutes } from '@/router/routes/admin/setting.ts'
import { userRoutes } from '@/router/routes/admin/user.ts'

export default [
  {
    path: `/admin`,
    component: () => import('@/layouts/admin.vue'),
    beforeEnter: [authMiddleware, permissionMiddleware],
    children: [
      {
        path: '',
        name: 'admin.dashboard',
        component: () => import('@/pages/Admin/Dashboard/Index.vue'),
        meta: {
          title: 'admin::sidebar.dashboard',
          pageHeader: false,
        },
      },
      ...branchRoutes,
      ...inventoryRoutes,
      ...userRoutes,
      ...localizationRoutes,
      ...reportRoutes,
      ...activityLogRoutes,
      ...settingRoutes,
      ...mediaRoutes,
      ...printerRoutes,
      ...seatingPlanRoutes,
      ...menuRoutes,
      ...optionRoutes,
      ...postRoutes,
      ...saleRoutes,
      ...promotionRoutes,
      ...loyaltyRoutes,
    ],
  },
] as RouteRecordRaw[]
