export const optionRoutes = [
  {
    path: 'options',
    name: 'admin.options',
    meta: {
      title: 'admin::sidebar.options',
      icon: 'tabler-adjustments',
    },
    children: [
      {
        path: '',
        name: 'admin.options.index',
        component: () => import('@/pages/Admin/Option/Index.vue'),
        meta: {
          permission: 'admin.options.index',
        },
      },
      {
        path: 'create',
        name: 'admin.options.create',
        component: () => import('@/pages/Admin/Option/Create.vue'),
        meta: {
          title: 'admin::resource.create',
          transParam: { resource: 'option::options.option' },
          permission: 'admin.options.create',
        },
      },
      {
        path: ':id/edit',
        name: 'admin.options.edit',
        component: () => import('@/pages/Admin/Option/Edit.vue'),
        meta: {
          title: 'admin::resource.edit',
          transParam: { resource: 'option::options.option' },
          permission: 'admin.options.edit',
        },
      },
    ],
  },
]
