<?php

namespace Modules\Cart\Http\Controllers\Api\V1\EditOrder;

use Darryldecode\Cart\Exceptions\InvalidConditionException;
use Illuminate\Http\JsonResponse;
use Modules\Cart\Facades\EditOrderCart;
use Modules\Core\Http\Controllers\Controller;
use Modules\Support\ApiResponse;
use Modules\User\Enums\DefaultRole;
use Modules\User\Models\User;

class CartCustomerController extends Controller
{
    /**
     * Add Customer to cart
     *
     * @param int $id
     * @return JsonResponse
     * @throws InvalidConditionException
     */
    public function store(int $id): JsonResponse
    {
        EditOrderCart::addCustomer(User::role(DefaultRole::Customer)->findOrFail($id));

        return ApiResponse::success(EditOrderCart::instance());
    }

    /**
     * Remove customer from cart
     *
     * @return JsonResponse
     */
    public function destroy(): JsonResponse
    {
        EditOrderCart::removeCustomer();

        return ApiResponse::success(EditOrderCart::instance());
    }
}
