<?php

namespace Modules\Cart\Http\Controllers\Api\V1\Pos;

use Darryldecode\Cart\Exceptions\InvalidConditionException;
use Illuminate\Http\JsonResponse;
use Modules\Cart\Facades\PosCart;
use Modules\Core\Http\Controllers\Controller;
use Modules\Support\ApiResponse;
use Modules\User\Enums\DefaultRole;
use Modules\User\Models\User;

class CartCustomerController extends Controller
{
    /**
     * Add Customer to cart
     *
     * @param int $id
     * @return JsonResponse
     * @throws InvalidConditionException
     */
    public function store(int $id): JsonResponse
    {
        PosCart::addCustomer(User::role(DefaultRole::Customer)->findOrFail($id));

        return ApiResponse::success(PosCart::instance());
    }
    
    /**
     * Remove customer from cart
     *
     * @return JsonResponse
     */
    public function destroy(): JsonResponse
    {
        PosCart::removeCustomer();

        return ApiResponse::success(PosCart::instance());
    }
}
