<?php

namespace Modules\Order\Listeners;

use Exception;
use Modules\Order\Enums\OrderStatus;
use Modules\Order\Events\OrderUpdateStatus;
use Modules\Order\Services\Order\OrderServiceInterface;
use Modules\Printer\Enum\PrinterRole;

class KitchenPrint
{
    /**
     * Handle the event.
     */
    public function handle(OrderUpdateStatus $event): void
    {
        try {
            if ($event->status === OrderStatus::Preparing) {
                app(OrderServiceInterface::class)
                    ->print($event->order->id, [PrinterRole::Kitchen]);
            }
        } catch (Exception) {
        }
    }
}
