<?php

namespace Modules\Printer\Providers;

use Illuminate\Contracts\Support\DeferrableProvider;
use Illuminate\Support\ServiceProvider;
use Modules\Printer\Services\Printer\PrinterService;
use Modules\Printer\Services\Printer\PrinterServiceInterface;

class DeferredPrinterServiceProvider extends ServiceProvider implements DeferrableProvider
{
    /**
     * Boot the application events.
     */
    public function register(): void
    {
        $this->app->singleton(
            abstract: PrinterServiceInterface::class,
            concrete: fn($app) => $app->make(PrinterService::class)
        );
    }

    /**
     * Get the services provided by the provider.
     */
    public function provides(): array
    {
        return [
            PrinterServiceInterface::class,
        ];
    }
}
