<?php

namespace Modules\Tax\Enums;

use Modules\Support\Traits\EnumArrayable;
use Modules\Support\Traits\EnumTranslatable;

enum TaxType: string
{
    use EnumTranslatable, EnumArrayable;

    case Inclusive = "inclusive";
    case Exclusive = "exclusive";

    /** @inheritDoc */
    public static function getTransKey(): string
    {
        return "tax::enums.tax_types";
    }
}
