<?php

namespace Modules\Cart\Http\Controllers\Api\V1\Pos;

use Illuminate\Http\JsonResponse;
use Modules\Cart\Facades\PosCart;
use Modules\Core\Http\Controllers\Controller;
use Modules\Support\ApiResponse;

class CartController extends Controller
{
    /**
     * Get a new instance of cart
     *
     * @return JsonResponse
     */
    public function index(): JsonResponse
    {
        return ApiResponse::success(PosCart::instance());
    }

    /**
     * Clear the cart.
     *
     * @return JsonResponse
     */
    public function clear(): JsonResponse
    {
        PosCart::clear();

        return ApiResponse::success(PosCart::instance());
    }
}
