<?php

namespace Modules\Core\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class UpgradeCommand extends Command
{
    /**
     * The name and signature of the console command.
     */
    protected $signature = 'forkiva:upgrade';

    /**
     * The console command description.
     */
    protected $description = 'Command for upgrade forkiva.';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        Artisan::call('module:migrate', ['-a' => true, '--force' => true]);
        Artisan::call('permission:sync-permissions');
        Artisan::call('permission:sync-default-roles');
        Artisan::call('cache:clear');
        Artisan::call('config:clear');
    }
}
