<?php

namespace Modules\Pos\Providers;

use Illuminate\Contracts\Support\DeferrableProvider;
use Illuminate\Support\ServiceProvider;
use Modules\Pos\Services\Pos\PosService;
use Modules\Pos\Services\Pos\PosServiceInterface;
use Modules\Pos\Services\PosCashMovement\PosCashMovementService;
use Modules\Pos\Services\PosCashMovement\PosCashMovementServiceInterface;
use Modules\Pos\Services\PosRegister\PosRegisterService;
use Modules\Pos\Services\PosRegister\PosRegisterServiceInterface;
use Modules\Pos\Services\PosSession\PosSessionService;
use Modules\Pos\Services\PosSession\PosSessionServiceInterface;

class DeferredPosServiceProvider extends ServiceProvider implements DeferrableProvider
{
    /**
     * Boot the application events.
     */
    public function register(): void
    {
        $this->app->singleton(
            abstract: PosRegisterServiceInterface::class,
            concrete: fn($app) => $app->make(PosRegisterService::class)
        );

        $this->app->singleton(
            abstract: PosSessionServiceInterface::class,
            concrete: fn($app) => $app->make(PosSessionService::class)
        );

        $this->app->singleton(
            abstract: PosCashMovementServiceInterface::class,
            concrete: fn($app) => $app->make(PosCashMovementService::class)
        );

        $this->app->singleton(
            abstract: PosServiceInterface::class,
            concrete: fn($app) => $app->make(PosService::class)
        );
    }

    /**
     * Get the services provided by the provider.
     */
    public function provides(): array
    {
        return [
            PosRegisterServiceInterface::class,
            PosSessionServiceInterface::class,
            PosCashMovementServiceInterface::class,
            PosServiceInterface::class
        ];
    }
}
