<?php

namespace Modules\Cart\Http\Controllers\Api\V1\EditOrder;

use Darryldecode\Cart\Exceptions\InvalidItemException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Modules\Cart\Facades\EditOrderCart;
use Modules\Cart\Http\Requests\Api\V1\StoreCartItemActionRequest;
use Modules\Cart\Http\Requests\Api\V1\StoreCartItemRequest;
use Modules\Core\Http\Controllers\Controller;
use Modules\Support\ApiResponse;

class CartItemController extends Controller
{
    /**
     * Store a newly created resource in storage.
     *
     * @param StoreCartItemRequest $request
     * @return JsonResponse
     * @throws InvalidItemException
     */
    public function store(StoreCartItemRequest $request): JsonResponse
    {
        EditOrderCart::store(
            $request->product_id,
            $request->qty,
            $request->options ?? [],
        );

        return ApiResponse::success(EditOrderCart::instance());
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param string $id
     * @return JsonResponse
     */
    public function update(Request $request, string $id): JsonResponse
    {
        if (!isset(EditOrderCart::get($id)['attributes']['loyalty_gift']['id'])) {
            EditOrderCart::updateQuantity($id, $request->qty ?: 1);
        }
        
        return ApiResponse::success(EditOrderCart::instance());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param string $id
     * @return JsonResponse
     */
    public function destroy(string $id): JsonResponse
    {
        if (!isset(EditOrderCart::get($id)['attributes']['loyalty_gift']['id'])) {
            EditOrderCart::remove($id);
        }

        return ApiResponse::success(EditOrderCart::instance());
    }

    /**
     * Store action
     *
     * @param StoreCartItemActionRequest $request
     * @param string $id
     * @return JsonResponse
     */
    public function storeAction(StoreCartItemActionRequest $request, string $id): JsonResponse
    {
        if (!isset(EditOrderCart::get($id)['attributes']['loyalty_gift']['id'])) {
            EditOrderCart::storeAction($id, $request->action, $request->qty);
        }

        return ApiResponse::success(EditOrderCart::instance());
    }

    /**
     * Remove action
     *
     * @param StoreCartItemActionRequest $request
     * @param string $id
     * @return JsonResponse
     */
    public function destroyAction(Request $request, string $id): JsonResponse
    {
        EditOrderCart::deleteAction($id, $request->action);

        return ApiResponse::success(EditOrderCart::instance());
    }
}
