<?php

namespace Modules\Cart\Listeners;

use Exception;
use Modules\Cart\Facades\PosCart;
use Modules\Order\Enums\OrderType;
use Modules\Order\Events\OrderCreated;

class ClearCart
{
    /**
     * Handle the event.
     */
    public function handle(OrderCreated $event): void
    {
        PosCart::clear();

        if ($event->order->type != OrderType::DineIn) {
            try {
                PosCart::addOrderType($event->order->type);
            } catch (Exception) {
            }
        }
    }
}
