import { api } from '@/api'

export function show (id: number, returnAllTranslations = false) {
  return api.get(`/v1/menus/${id}`, { params: { return_all_translations: returnAllTranslations } })
}

export function update (id: number, item: Record<string, any>) {
  return api.put(`/v1/menus/${id}`, item)
}

export function store (item: Record<string, any>) {
  return api.post(`/v1/menus`, item)
}

export function getFormMeta () {
  return api.get(`/v1/menus/form/meta`)
}
