import { api } from '@/api'

export function get () {
  return api.get('/v1/pos')
}

export function getKitchenViewer () {
  return api.get('/v1/pos/kitchen-viewer')
}

export function moveOrderToNextStatus (id: number | string) {
  return api.patch(`/v1/pos/kitchen-viewer/${id}/move-to-next-status`)
}

export function searchCustomers (query: string) {
  return api.get('/v1/pos/search/customers', { params: { query } })
}
