import { api } from '@/api'

export function show (id: number, returnAllTranslations = false) {
  return api.get(`/v1/pos/registers/${id}`, { params: { return_all_translations: returnAllTranslations } })
}

export function update (id: number, item: Record<string, any>) {
  return api.put(`/v1/pos/registers/${id}`, item)
}

export function store (item: Record<string, any>) {
  return api.post(`/v1/pos/registers`, item)
}

export function getFormMeta () {
  return api.get(`/v1/pos/registers/form/meta`)
}
