import { api } from '@/api'

export function show (id: number, returnAllTranslations = false) {
  return api.get(`/v1/vouchers/${id}`, { params: { return_all_translations: returnAllTranslations } })
}

export function update (id: number, item: Record<string, any>) {
  return api.put(`/v1/vouchers/${id}`, item)
}

export function store (item: Record<string, any>) {
  return api.post(`/v1/vouchers`, item)
}

export function getFormMeta () {
  return api.get(`/v1/vouchers/form/meta`)
}
