import type { SettingSection } from '@/enums/settingSection.ts'
import { api } from '@/api'

export function getAppSettings () {
  return api.get('/v1/app/settings')
}

export function getSettings (section: SettingSection) {
  return api.get(`/v1/settings/${section}`)
}

export function update (section: SettingSection, data: object) {
  return api.put(`/v1/settings/${section}/update`, data)
}
