export interface Money {
  amount: number
  formatted: string
  currency: string
}

export interface CartItemOptionValue {
  id: number
  label: string
  price: Money
}

export interface CartItemOption {
  id: number
  name: string
  values: CartItemOptionValue[]
}

export interface CartItemProduct {
  id: number
  name: string
  thumbnail: string | null
}

export interface CartTax {
  id: number
  name: string
  amount: Money
}

export interface loyaltyGift {
  id: number
}

export interface CartItem {
  id: string
  qty: number
  item: CartItemProduct
  options: Record<string, CartItemOption>
  unitPrice: Money
  subtotal: Money
  taxTotal: Money
  taxes: CartTax[]
  loyaltyGift?: loyaltyGift
  actions: CartItemAction[]
  orderProduct?: OrderProduct
  total: Money
}

export interface CartItemAction {
  id: string
  quantity: number
}

export interface OrderProductStatus {
  id: string
  name: string
  icon: string
  color: string
}

export interface OrderProduct {
  id: number
  status: OrderProductStatus
}

export interface OrderType {
  id?: string | null
  name?: string | null
}

export interface Discount {
  id?: string | null
  name?: string | null
  value: Money
}

export interface Customer {
  id: string
  name: string
}

export interface CartResponse {
  items: CartItem[]
  quantity: number
  subTotal: Money
  orderType: OrderType
  taxes: CartTax[]
  discount?: Discount
  customer: { id: number, name: string } | null
  total: Money
}

export interface Cart {
  response: CartResponse
  mode: 'create' | 'edit'
  orderId?: number | string | null
  searchQuery: string | null
  tableInfo: Record<string, any> | null
  checkoutStep: 'cart' | 'summary'
  paymentMethods: string[]
  refund_payment_method?: string | null
  payments: Record<string, any>
  posRegisterId: number | null
  notes: string | null
  tableId: number | null
  guestCount: number
  paymentType: string
  amountToBePaid: number
  carPlate: string | null
  carDescription: string | null
  scheduledAt: string | null
  disabled: boolean
}
