<?php

namespace Modules\Branch\Transformers\Api\V1;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Branch\Models\Branch;

/** @mixin Branch */
class BranchResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "name" => $this->name,
            "registration_number" => $this->registration_number,
            "address" => $this->address,
            "phone" => $this->phone,
            "email" => $this->email,
            "latitude" => $this->latitude,
            "longitude" => $this->longitude,
            "country_name" => $this->getCountryName(),
            "country_code" => $this->country_code,
            "timezone" => $this->timezone,
            "currency" => $this->currency,
            "is_active" => $this->is_active,
            "is_main" => $this->is_main,
            "order_types" => $this->order_types,
            "payment_methods" => $this->payment_methods,
            "cash_difference_threshold" => $this->cash_difference_threshold,
            "created_at" => dateTimeFormat($this->created_at),
            "updated_at" => dateTimeFormat($this->updated_at),
        ];
    }
}
