<?php

namespace Modules\Branch\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Branch\Models\Branch;
use Modules\Order\Enums\OrderType;
use Modules\Payment\Enums\PaymentMethod;

class BranchFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     */
    protected $model = Branch::class;

    /**
     * Define the model's default state.
     */
    public function definition(): array
    {
        return [
            'name' => 'Forkiva ' . $this->faker->city . ' Branch',
            'address' => $this->faker->streetAddress . ', Amman, Jordan',
            'phone' => '+962 ' . $this->faker->numerify('7########'),
            'email' => $this->faker->unique()->safeEmail,
            'country_code' => 'JO',
            'timezone' => 'Asia/Amman',
            'currency' => 'JOD',
            'latitude' => $this->faker->latitude(31.8, 32.1),
            'longitude' => $this->faker->longitude(35.8, 36.0),
            "order_types" => OrderType::values(),
            "payment_methods" => $this->faker->randomElement(PaymentMethod::values()),
            'is_active' => true,
        ];
    }
}

