<?php

use Modules\Cart\Http\Controllers\Api\V1\Pos\CartController;
use Modules\Cart\Http\Controllers\Api\V1\Pos\CartCustomerController;
use Modules\Cart\Http\Controllers\Api\V1\Pos\CartDiscountController;
use Modules\Cart\Http\Controllers\Api\V1\Pos\CartGiftController;
use Modules\Cart\Http\Controllers\Api\V1\Pos\CartItemController;
use Modules\Cart\Http\Controllers\Api\V1\Pos\CartOrderTypeController;
use Modules\Cart\Http\Controllers\Api\V1\Pos\CartVoucherController;
use Modules\Order\Enums\OrderType;

Route::prefix('cart')
    ->middleware("can:admin.pos.index")
    ->group(function () {
        Route::prefix('pos')
            ->group(function () {
                Route::controller(CartController::class)
                    ->group(function () {
                        Route::get('', 'index');
                        Route::delete('clear', 'clear');
                    });

                Route::controller(CartItemController::class)
                    ->prefix('items')
                    ->group(function () {
                        Route::post('', 'store');
                        Route::put('{itemId}', 'update');
                        Route::delete('{itemId}', 'destroy');
                    });

                Route::controller(CartDiscountController::class)
                    ->prefix('discounts')
                    ->group(function () {
                        Route::post('{id}', 'store');
                        Route::delete('', 'destroy');
                    });

                Route::controller(CartVoucherController::class)
                    ->prefix('vouchers')
                    ->group(function () {
                        Route::post('', 'store');
                    });

                Route::controller(CartCustomerController::class)
                    ->prefix('customers')
                    ->group(function () {
                        Route::post('{id}', 'store');
                        Route::delete('', 'destroy');
                    });

                Route::controller(CartOrderTypeController::class)
                    ->prefix('order-types')
                    ->group(function () {
                        Route::post('{type}', 'store')
                            ->whereIn('type', OrderType::values());
                        Route::delete('', 'destroy');
                    });

                Route::controller(CartGiftController::class)
                    ->prefix('gifts')
                    ->group(function () {
                        Route::post('{id}', 'store');
                    });
            });
        Route::prefix('edit-order')
            ->group(function () {
                Route::controller(\Modules\Cart\Http\Controllers\Api\V1\EditOrder\CartItemController::class)
                    ->prefix('items')
                    ->group(function () {
                        Route::post('', 'store');
                        Route::put('{itemId}', 'update');
                        Route::delete('{itemId}', 'destroy');
                        Route::post('{itemId}/action', 'storeAction');
                        Route::delete('{itemId}/action', 'destroyAction');
                    });

                Route::controller(\Modules\Cart\Http\Controllers\Api\V1\EditOrder\CartDiscountController::class)
                    ->prefix('discounts')
                    ->group(function () {
                        Route::post('{id}', 'store');
                        Route::delete('', 'destroy');
                    });

                Route::controller(\Modules\Cart\Http\Controllers\Api\V1\EditOrder\CartCustomerController::class)
                    ->prefix('customers')
                    ->group(function () {
                        Route::post('{id}', 'store');
                        Route::delete('', 'destroy');
                    });

                Route::controller(\Modules\Cart\Http\Controllers\Api\V1\EditOrder\CartVoucherController::class)
                    ->prefix('vouchers')
                    ->group(function () {
                        Route::post('', 'store');
                    });

                Route::controller(\Modules\Cart\Http\Controllers\Api\V1\EditOrder\CartGiftController::class)
                    ->prefix('gifts')
                    ->group(function () {
                        Route::post('{id}', 'store');
                    });
            });
    });
