<?php

namespace Modules\Order\Enums;

use Modules\Discount\Models\Discount;
use Modules\Support\Traits\EnumArrayable;
use Modules\Support\Traits\EnumTranslatable;
use Modules\Voucher\Models\Voucher;

enum OrderDiscountType: string
{
    use EnumTranslatable, EnumArrayable;

    case Discount = "discount";
    case Voucher = "voucher";

    /** @inheritDoc */
    public static function getTransKey(): string
    {
        return "order::enums.order_discount_types";
    }

    /**
     * Get discount type from model
     *
     * @param string|null $model
     * @return OrderDiscountType|null
     */
    public static function getTypeFromModel(?string $model = null): ?OrderDiscountType
    {
        return match ($model) {
            Discount::class => OrderDiscountType::Discount,
            Voucher::class => OrderDiscountType::Voucher,
            default => null,
        };
    }
}
