<?php

namespace Modules\Order\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Modules\Order\Events\OrderCreated;
use Modules\Order\Events\OrderUpdateStatus;
use Modules\Order\Listeners\DeductOrderStock;
use Modules\Order\Listeners\HandleOrderLoyaltyPoints;
use Modules\Order\Listeners\KitchenPrint;
use Modules\Order\Listeners\MarkTableAsFree;
use Modules\Order\Listeners\OrderRefundAmount;
use Modules\Order\Listeners\RestoreOrderStock;
use Modules\Order\Listeners\StoreOrderStatusLogo;
use Modules\Order\Listeners\UpdateOrderProductStatus;
use Modules\Order\Listeners\UpdateOrderStatus;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        OrderUpdateStatus::class => [
            StoreOrderStatusLogo::class,
            OrderRefundAmount::class,
            MarkTableAsFree::class,
            DeductOrderStock::class,
            RestoreOrderStock::class,
            UpdateOrderProductStatus::class,
            KitchenPrint::class,
            HandleOrderLoyaltyPoints::class,
        ],
        OrderCreated::class => [
            UpdateOrderStatus::class,
        ]
    ];
}
