<?php

namespace Modules\Order\Services\CreateOrder;

use Modules\Order\Models\Order;
use Modules\Pos\Models\PosSession;
use Modules\User\Models\User;
use Throwable;

interface CreateOrderServiceInterface
{
    /**
     * Store a newly created resource in storage.
     *
     * @param array $data
     * @return Order
     * @throws Throwable
     */
    public function create(array $data): Order;

    /**
     * Store order payments
     *
     * @param User $user
     * @param Order $order
     * @param PosSession|null $posSession
     * @param array $data
     * @return void
     * @throws Throwable
     */
    public function storePayments(
        User            $user,
        Order           $order,
        PosSession|null $posSession,
        array           $data,
    ): void;
}
