<?php

namespace Modules\Pos\Services\Pos;

use Illuminate\Http\Resources\Json\AnonymousResourceCollection;
use Modules\Menu\Models\Menu;

interface PosServiceInterface
{
    /**
     * Display a listing of the resource.
     *
     * @return array
     */
    public function get(): array;

    /**
     * Get kitchen viewer data
     *
     * @return array
     */
    public function kitchenViewer(): array;

    /**
     * Get tree categories for pos
     *
     * @param Menu $menu
     * @return AnonymousResourceCollection
     */
    public function getCategories(Menu $menu): AnonymousResourceCollection;

    /**
     * Get products for pos
     *
     * @param Menu $menu
     * @return AnonymousResourceCollection
     */
    public function getProducts(Menu $menu): AnonymousResourceCollection;
}
